%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NISP on L96 model
% of example 4.10
% Created by by John Harlim
% Last edited: March 20, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all, close all

J = 40;
T = 100;
u0 = sin([1:J]*2*pi/J)';
dt = 0.05;
mode = 5;

% generate Smolyak sparse grid
D = 2; % dimension
L = 8; % Smolyak level
[Y w] = nwspgr(@ccfornwspgr, D, L);

% Integrate model at Smolyak grid
K = size(Y,1);
theta1 = 1+.2*Y(:,1);
theta2 = 8+Y(:,2);

for j=1:K
    u(:,j,:) = l96rk4(theta1(j),theta2(j),u0,T);
end

% evaluate Legendre polynomials on Smolyak grid
N = 100;
Phi = zeros(size(Y,1),size(Y,2),N+1);
P1 = ones(size(Y,1),size(Y,2));
P2 = Y;
Phi(:,:,1) = P1;
Phi(:,:,2) = P2;
for j=2:N                
    Phi(:,:,j+1) = (2*(j-1)+1)/j*Y.*P2 - (j-1)/j*P1;
    P1 = P2;
    P2 = Phi(:,:,j+1);
end

% integrate the expansion coefficients
multiindex = generatemultiindex(N,D);
P = size(multiindex,2);

uhat = zeros(P,T+1);
for i=1:P
    uhat(i,:) = w'*(squeeze(u(mode,:,:)).*repmat(Phi(:,1,multiindex(1,i)+1).*Phi(:,2,multiindex(2,i)+1),1,T+1));
end

ubar1 = uhat(1,:);
vbar1 = sum(uhat(2:P,:).^2);

grey = [.4 .4 .4];
plot([0:dt:dt*T],ubar1,'*','color',grey,'linewidth',2)
hold on
plot([0:dt:dt*T],ubar1+sqrt(vbar1),'*','color',grey)
plot([0:dt:dt*T],ubar1-sqrt(vbar1),'*','color',grey)
hold off
set(gca,'fontsize',16)
xlabel('time')
ylabel('u_5')

return 

%%% to plot the MonteCarlo solution, run example49mc.m first

load montecarloL96
hold on
plot([0:dt:dt*T],ubar(mode,:),'k--','linewidth',2)
plot([0:dt:dt*T],ubar(mode,:)+sqrt(vbar(mode,:)),'k--')
plot([0:dt:dt*T],ubar(mode,:)-sqrt(vbar(mode,:)),'k--')
hold off
set(gca,'fontsize',16)
xlabel('t')
ylabel('u_5')

print -depsc -r100 nispL96.eps

save nispL96 ubar1 vbar1 dt T 

